package decoratorexample;

import java.util.Iterator;
import java.util.List;

/**
 * Questa classe estende le funzionalità di LineWriter aggiungendo la funzionalità
 * di conteggio delle occorrenze della lettera 's'.
 * @author Giuseppe Cota <giuseppe.cota@unife.it>
 */
public class LetterSCounterLineWriterDecorator extends LineWriterDecorator {

    public LetterSCounterLineWriterDecorator(LineWriter lw) {
        super(lw);
    }

    protected void countS(List<String> storage) {
        int tot = 0;
        Iterator<String> it = storage.iterator();
        while (it.hasNext()) {
            String line = it.next();
            tot += line.length() - line.replace("s", "").length();
        }
        System.out.println("Totale occorrenze lettera s: " + tot);
    }

    public void printAllLines(List<String> storage) {
        super.printAllLines(storage);
        countS(storage);
    }
}
